/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.euser.live.tokenvalidator.validatorimpl;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.exception.ApiException;
import tech.gtt.common.base.token.TokenObject;
import tech.gtt.common.base.token.TokenTools;
import tech.gtt.euser.live.tokenvalidator.ITokenValidator;
import tech.gtt.euser.live.tokenvalidator.annotation.TokenValidator;
import tech.gtt.euser.live.tokenvalidator.bean.AccountToken;
import tech.gtt.euser.live.tokenvalidator.bean.ValidatorCheckResultEndUser;
import tech.gtt.euser.live.tokenvalidator.enums.ValidateResultStatusCodeEnum;

@TokenValidator(order=100)
public class TokenValidatorFor3x
implements ITokenValidator {
    private static final Logger logger = LoggerFactory.getLogger(TokenValidatorFor3x.class);
    private static final String ACCOUNT_TOKEN_KEY = "aJhsuTA1JKyM4H9ShRD7lA==";

    @Override
    public ValidatorCheckResultEndUser checkToken(String token, String mac, String loginId) {
        AccountToken accountToken;
        ValidatorCheckResultEndUser checkResult = new ValidatorCheckResultEndUser();
        try {
            accountToken = this.parseAccountToken(token);
        }
        catch (Exception e) {
            logger.error(String.format("[enduser-token-validator] Error in Parse 3.x Token:[%s]", token), (Throwable)e);
            checkResult.setTokenIllegal(true);
            return checkResult;
        }
        if (accountToken.getVersion() == 20170101 && !StringUtils.equals((CharSequence)accountToken.getDid(), (CharSequence)mac)) {
            logger.error("[enduser-token-validator]token(3.x) is invalid: mac is mismatched, mac={} tokenMac={} token={}", new Object[]{mac, accountToken.getDid(), token});
            checkResult.setStatusCode(ValidateResultStatusCodeEnum.MAC_MISMATCH.getStatusCode());
            checkResult.setStatusDescription(ValidateResultStatusCodeEnum.MAC_MISMATCH.getStatusDescription());
            return checkResult;
        }
        if (accountToken.getVersion() == 20171216 && !StringUtils.equals((CharSequence)accountToken.getLoginId(), (CharSequence)loginId)) {
            logger.error("[enduser-token-validator]token(3.x) is invalid: loginId is mismatched, loginId={} tokenLoginId={} token={}", new Object[]{loginId, accountToken.getLoginId(), token});
            checkResult.setStatusCode(ValidateResultStatusCodeEnum.LOGINID_MISMATCH.getStatusCode());
            checkResult.setStatusDescription(ValidateResultStatusCodeEnum.LOGINID_MISMATCH.getStatusDescription());
            return checkResult;
        }
        long tokenExpiredTime = accountToken.getEt();
        if (System.currentTimeMillis() > tokenExpiredTime) {
            logger.error("[enduser-token-validator]token(3.x) is invalid: account token is expired, tokenExpiredTime={} token={}", (Object)tokenExpiredTime, (Object)token);
            checkResult.setStatusCode(ValidateResultStatusCodeEnum.EXPIRED.getStatusCode());
            checkResult.setStatusDescription(ValidateResultStatusCodeEnum.EXPIRED.getStatusDescription());
            return checkResult;
        }
        checkResult.setStatusCode(ValidateResultStatusCodeEnum.VALID.getStatusCode());
        checkResult.setStatusDescription(ValidateResultStatusCodeEnum.VALID.getStatusDescription());
        checkResult.setExpiredTime(tokenExpiredTime);
        checkResult.setDid(accountToken.getDid());
        checkResult.setAccountId(accountToken.getAccountId());
        return checkResult;
    }

    private AccountToken parseAccountToken(String token) throws ApiException {
        TokenObject tokenObject = TokenTools.decodeToken((String)ACCOUNT_TOKEN_KEY, (String)token);
        AccountToken accountToken = new AccountToken();
        accountToken.setLoginId(tokenObject.getStringValue("li"));
        accountToken.setDid(tokenObject.getStringValue("di"));
        accountToken.setG(tokenObject.getStringValue("g"));
        accountToken.setP(tokenObject.getStringValue("p"));
        accountToken.setCt(tokenObject.getLongValue("ct"));
        accountToken.setEt(tokenObject.getLongValue("et"));
        accountToken.setVersion(Long.valueOf(tokenObject.getLongValue("v")).intValue());
        accountToken.setServiceExpire(tokenObject.getLongValue("se"));
        accountToken.setProperties(tokenObject.getLongValue("pr"));
        accountToken.setLoginMethod(Long.valueOf(tokenObject.getLongValue("lm")).intValue());
        accountToken.setClientSession(tokenObject.getStringValue("cs"));
        accountToken.setClientId(tokenObject.getLongValue("ci"));
        accountToken.setProductId(tokenObject.getStringValue("pid"));
        accountToken.setIsSTBApk(Long.valueOf(tokenObject.getLongValue("stb")).intValue());
        accountToken.setVnoId(tokenObject.getStringValue("vid"));
        accountToken.setBrandId(tokenObject.getStringValue("bid"));
        accountToken.setAppId(tokenObject.getStringValue("apid"));
        accountToken.setAccountId(tokenObject.getLongValue("aid"));
        accountToken.setSccAccountType(Long.valueOf(tokenObject.getLongValue("sat")).intValue());
        accountToken.setOnlineLimit(tokenObject.getStringValue("ol"));
        accountToken.setSessionStr(tokenObject.getLongValue("ss"));
        accountToken.setClientType(tokenObject.getStringValue("clt"));
        accountToken.setDeviceId(tokenObject.getStringValue("deid"));
        accountToken.setLimitCount(tokenObject.getStringValue("lc"));
        return accountToken;
    }
}

