/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.structlog4j.extend;

import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import tech.ibit.structlog4j.Formatter;

public class YamlFormatter
implements Formatter {
    private static final ThreadLocal<Yaml> YAML = ThreadLocal.withInitial(() -> {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        return new Yaml(options);
    });
    private static final YamlFormatter INSTANCE = new YamlFormatter();

    public static YamlFormatter getInstance() {
        return INSTANCE;
    }

    public String format(Map<String, ?> kvMap) {
        if (null == kvMap || kvMap.isEmpty()) {
            return this.formatString(YAML.get().dump(kvMap).trim());
        }
        HashMap newKvMap = new HashMap();
        kvMap.forEach((k, v) -> {
            if (v instanceof String) {
                newKvMap.put(k, this.formatString((String)v));
            } else {
                newKvMap.put(k, v);
            }
        });
        return this.formatString(YAML.get().dump(newKvMap).trim());
    }
}

