/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package tv.danmaku.ijk.media.exo;
/*
import static com.google.android.exoplayer2.audio.AudioCapabilities.DEFAULT_AUDIO_CAPABILITIES;
import static com.google.android.exoplayer2.util.Assertions.checkNotNull;
import static com.google.android.exoplayer2.util.Util.constrainValue;
import static com.google.common.base.MoreObjects.firstNonNull;
import static java.lang.Math.max;
import static java.lang.Math.min;
import static java.lang.annotation.ElementType.TYPE_USE;

import android.annotation.SuppressLint;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.media.PlaybackParams;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.DoNotInline;
import androidx.annotation.IntDef;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.audio.AudioProcessor.UnhandledAudioFormatException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.errorprone.annotations.InlineMe;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
*/
import android.content.Context;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import java.nio.ByteBuffer;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import android.util.Log;

import com.google.android.exoplayer2.audio.AudioSink;
import com.google.android.exoplayer2.audio.DefaultAudioSink;

public final class IjkAudioSink implements AudioSink {
    public class AudioStat {
        public long writeCount;
        public long finishCount;
        public long prevfinishCount;
        public long exceptionCount;
        public AudioStat() {
            
        }
    };
    AudioStat audioStat;
    DefaultAudioSink asink;
    public IjkAudioSink(Context context,
    boolean enableFloatOutput,
    boolean enableAudioTrackPlaybackParams,
    boolean enableOffload) {
        audioStat = new AudioStat();
        asink =  new DefaultAudioSink.Builder()
              .setAudioCapabilities(AudioCapabilities.getCapabilities(context))
              .setEnableFloatOutput(enableFloatOutput)
              .setEnableAudioTrackPlaybackParams(enableAudioTrackPlaybackParams)
              .setOffloadMode(
                enableOffload
                ? DefaultAudioSink.OFFLOAD_MODE_ENABLED_GAPLESS_REQUIRED
                : DefaultAudioSink.OFFLOAD_MODE_DISABLED)
              .build();
    }
    public AudioStat getAudioStat() {
        return audioStat;
    }

    @Override
    public void setListener(Listener listener) {
        asink.setListener(listener);
    }
    @Override
    public void setPlayerId(@Nullable PlayerId playerId) {
        asink.setPlayerId(playerId);
    }
    @Override
    public boolean supportsFormat(Format format) {
        return asink.getFormatSupport(format) != SINK_FORMAT_UNSUPPORTED;
    }
    @Override
    public @SinkFormatSupport int getFormatSupport(Format format) {
      return asink.getFormatSupport(format);
    }
    
    @Override
    public long getCurrentPositionUs(boolean sourceEnded) {
        return asink.getCurrentPositionUs(sourceEnded);
    }
    @Override
    public void configure(Format inputFormat, int specifiedBufferSize, @Nullable int[] outputChannels)
        throws ConfigurationException {
        asink.configure(inputFormat, specifiedBufferSize, outputChannels);
    }
    @Override
    public void play() {
        asink.play();
    }
    @Override
    public void handleDiscontinuity() {
        asink.handleDiscontinuity();
    }
  
    @Override
    @SuppressWarnings("ReferenceEquality")
    public boolean handleBuffer(ByteBuffer buffer, long presentationTimeUs, int encodedAccessUnitCount)
        throws InitializationException, WriteException {
        audioStat.writeCount++;
        boolean writeResult = false;
        try {
            writeResult = asink.handleBuffer(buffer, presentationTimeUs,encodedAccessUnitCount);
        }catch (AudioSink.WriteException e) {
            Log.d("IjkAudioSInk", "write exception");
            audioStat.exceptionCount++;
            audioStat.finishCount = audioStat.writeCount;
            throw e;
        }
        audioStat.finishCount++;
        return writeResult;
    }
  
    @Override
    public void playToEndOfStream() throws WriteException {
        asink.playToEndOfStream();
    }
    @Override
    public boolean isEnded() {
        return asink.isEnded();
    }
    @Override
    public boolean hasPendingData() {
        return asink.hasPendingData();
    }
    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        asink.setPlaybackParameters(playbackParameters);
    }
  
    @Override
    public PlaybackParameters getPlaybackParameters() {
        return asink.getPlaybackParameters();
    }
  
    @Override
    public void setSkipSilenceEnabled(boolean skipSilenceEnabled) {
        asink.setSkipSilenceEnabled(skipSilenceEnabled);
    }
  
    @Override
    public boolean getSkipSilenceEnabled() {
        return asink.getSkipSilenceEnabled();
    }
  
    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        asink.setAudioAttributes(audioAttributes);
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        return asink.getAudioAttributes();
    }

    @Override
    public void setAudioSessionId(int audioSessionId) {
        asink.setAudioSessionId(audioSessionId);
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        asink.setAuxEffectInfo(auxEffectInfo);
    }
  
    @Override
    public void enableTunnelingV21() {
        asink.enableTunnelingV21();
    }
  
    @Override
    public void disableTunneling() {
        asink.disableTunneling();
    }
  
    @Override
    public void setVolume(float volume) {
        asink.setVolume(volume);
    }
  
    @Override
    public void pause() {
        asink.pause();
    }
  
    @Override
    public void flush() {
      asink.flush();
    }
    @Override
    public void experimentalFlushWithoutAudioTrackRelease() {
        asink.experimentalFlushWithoutAudioTrackRelease();
    }
    @Override
    public void reset() {
        asink.reset();
    }
}
