package tv.danmaku.ijk.media.drm.util;

import java.util.UUID;

public final class C {
    /**
     * Special constant representing an unset or unknown time or duration. Suitable for use in any
     * time base.
     */
    public static final long TIME_UNSET = Long.MIN_VALUE + 1;

    /**
     * Represents an unset or unknown index.
     */
    public static final int INDEX_UNSET = -1;

    /** Represents an unset or unknown length. */
    public static final int LENGTH_UNSET = -1;

    /**
     * A return value for methods where the end of an input was encountered.
     */
    public static final int RESULT_END_OF_INPUT = -1;

    /** The number of milliseconds in one second. */
    public static final long MILLIS_PER_SECOND = 1000L;

    /**
     * The Nil UUID as defined by
     * <a href="https://tools.ietf.org/html/rfc4122#section-4.1.7">RFC4122</a>.
     */
    public static final UUID UUID_NIL = new UUID(0L, 0L);

    /**
     * UUID for the W3C
     * <a href="https://w3c.github.io/encrypted-media/format-registry/initdata/cenc.html">Common PSSH
     * box</a>.
     */
    public static final UUID COMMON_PSSH_UUID = new UUID(0x1077EFECC0B24D02L, 0xACE33C1E52E2FB4BL);

    /**
     * UUID for the ClearKey DRM scheme.
     * <p>
     * ClearKey is supported on Android devices running Android 5.0 (API Level 21) and up.
     */
    public static final UUID CLEARKEY_UUID = new UUID(0xE2719D58A985B3C9L, 0x781AB030AF78D30EL);

    /**
     * UUID for the Widevine DRM scheme.
     * <p>
     * Widevine is supported on Android devices running Android 4.3 (API Level 18) and up.
     */
    public static final UUID WIDEVINE_UUID = new UUID(0xEDEF8BA979D64ACEL, 0xA3C827DCD51D21EDL);

    /**
     * UUID for the PlayReady DRM scheme.
     * <p>
     * PlayReady is supported on all AndroidTV devices. Note that most other Android devices do not
     * provide PlayReady support.
     */
    public static final UUID PLAYREADY_UUID = new UUID(0x9A04F07998404286L, 0xAB92E65BE0885F95L);

    /** A type constant for a fake or empty track. */
    public static final int TRACK_TYPE_NONE = -2;
    /** A type constant for tracks of unknown type. */
    public static final int TRACK_TYPE_UNKNOWN = -1;
    /** A type constant for tracks of some default type, where the type itself is unknown. */
    public static final int TRACK_TYPE_DEFAULT = 0;
    /** A type constant for audio tracks. */
    public static final int TRACK_TYPE_AUDIO = 1;
    /** A type constant for video tracks. */
    public static final int TRACK_TYPE_VIDEO = 2;
    /** A type constant for text tracks. */
    public static final int TRACK_TYPE_TEXT = 3;
    /** A type constant for image tracks. */
    public static final int TRACK_TYPE_IMAGE = 4;
    /** A type constant for metadata tracks. */
    public static final int TRACK_TYPE_METADATA = 5;
    /** A type constant for camera motion tracks. */
    public static final int TRACK_TYPE_CAMERA_MOTION = 6;
    /**
     * Applications or extensions may define custom {@code TRACK_TYPE_*} constants greater than or
     * equal to this value.
     */
    public static final int TRACK_TYPE_CUSTOM_BASE = 10000;

    /** "cenc" scheme type name as defined in ISO/IEC 23001-7:2016. */
    @SuppressWarnings("ConstantField")
    public static final String CENC_TYPE_cenc = "cenc";

    /** "cbc1" scheme type name as defined in ISO/IEC 23001-7:2016. */
    @SuppressWarnings("ConstantField")
    public static final String CENC_TYPE_cbc1 = "cbc1";

    /** "cens" scheme type name as defined in ISO/IEC 23001-7:2016. */
    @SuppressWarnings("ConstantField")
    public static final String CENC_TYPE_cens = "cens";

    /** "cbcs" scheme type name as defined in ISO/IEC 23001-7:2016. */
    @SuppressWarnings("ConstantField")
    public static final String CENC_TYPE_cbcs = "cbcs";
}
