package tv.danmaku.ijk.media.drm.wrapper;

import android.os.Build;

import java.util.Map;
import java.util.UUID;

import androidx.annotation.RequiresApi;

import tv.danmaku.ijk.media.drm.DefaultDrmSessionManager;
import tv.danmaku.ijk.media.drm.FrameworkMediaDrm;
import tv.danmaku.ijk.media.drm.HttpMediaDrmCallback;
import tv.danmaku.ijk.media.drm.MediaDrmCallback;
import tv.danmaku.ijk.media.drm.upstream.DefaultHttpDataSource;
import tv.danmaku.ijk.media.drm.upstream.HttpDataSource;
import tv.danmaku.ijk.media.drm.util.C;

@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
public class DefaultDrmManager extends AbsDrmManager {
    public DefaultDrmManager(String drmLicenceUrl, Map<String, String> httpRequestHeaders, UUID uuid, boolean multiSession) {
        super(drmLicenceUrl, httpRequestHeaders, uuid, multiSession);
    }

    @Override
    protected DefaultDrmSessionManager createManager(String licenseUrl,
                                                     Map<String, String> httpRequestHeaders,
                                                     UUID uuid,
                                                     boolean multiSession,
                                                     byte[] offlineLicenseKeySetId) {
        HttpDataSource.Factory dataSourceFactory = new DefaultHttpDataSource.Factory().setUserAgent("ijk-drm-http");
        HttpMediaDrmCallback httpMediaDrmCallback = new HttpMediaDrmCallback(licenseUrl, dataSourceFactory);
        for (Map.Entry<String, String> entry : httpRequestHeaders.entrySet()) {
            httpMediaDrmCallback.setKeyRequestProperty(entry.getKey(), entry.getValue());
        }
        return createManager(uuid, multiSession, offlineLicenseKeySetId, httpMediaDrmCallback);
    }

    private static DefaultDrmSessionManager createManager(
            UUID uuid, boolean multiSession, byte[] offlineLicenseKeySetId, MediaDrmCallback callback) {
        DefaultDrmSessionManager.Builder builder = new DefaultDrmSessionManager.Builder();
        if (multiSession) {
            builder.setSessionKeepaliveMs(C.TIME_UNSET);
        }
        DefaultDrmSessionManager drmSessionManager = builder
                .setUuidAndExoMediaDrmProvider(uuid, FrameworkMediaDrm.DEFAULT_PROVIDER)
                .setMultiSession(multiSession)
                .setUseDrmSessionsForClearContent(C.TRACK_TYPE_AUDIO, C.TRACK_TYPE_VIDEO)
                .build(callback);
        drmSessionManager.setMode(DefaultDrmSessionManager.MODE_PLAYBACK, offlineLicenseKeySetId);
        return drmSessionManager;
    }
}
