package tv.danmaku.ijk.media.player;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;

import androidx.annotation.RequiresApi;

@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
public interface IjkMediaCodecList {
    class Factory {
        public static IjkMediaCodecList create(boolean supportSecure) {
            IjkMediaCodecList codecList = null;
            if (supportSecure) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    codecList = new IjkMediaCodecListV21(MediaCodecList.ALL_CODECS);
                }
            }
            if (codecList == null) {
                codecList = new IjkMediaCodecListV16();
            }
            return codecList;
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    class IjkMediaCodecListV16 implements IjkMediaCodecList {
        @Override
        public final int getCodecCount() {
            return MediaCodecList.getCodecCount();
        }

        @Override
        public final MediaCodecInfo getCodecInfoAt(int index) {
            return MediaCodecList.getCodecInfoAt(index);
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    class IjkMediaCodecListV21 implements IjkMediaCodecList {
        private final MediaCodecInfo[] codecInfos;

        public IjkMediaCodecListV21(int kind) {
            MediaCodecList mediaCodecList = new MediaCodecList(kind);
            codecInfos = mediaCodecList.getCodecInfos();
        }

        @Override
        public final int getCodecCount() {
            return codecInfos.length;
        }

        @Override
        public final MediaCodecInfo getCodecInfoAt(int index) {
            return codecInfos[index];
        }
    }

    int getCodecCount();

    MediaCodecInfo getCodecInfoAt(int index);
}
