/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.Encoder;
import ws.schild.jave.EncoderException;
import ws.schild.jave.InputFormatException;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.EncodingAttributes;
import ws.schild.jave.encode.VideoAttributes;
import ws.schild.jave.process.ProcessLocator;
import ws.schild.jave.process.ffmpeg.DefaultFFMPEGLocator;
import ws.schild.jave.progress.EncoderProgressAdapter;
import ws.schild.jave.progress.EncoderProgressListener;
import ws.schild.jave.progress.VideoProgressListener;
import ws.schild.jave.utils.AutoRemoveableFile;

public class VideoProcessor {
    private static final Logger logger = LoggerFactory.getLogger(VideoProcessor.class);
    private static boolean enabled = false;
    private Encoder encoder;
    private ProcessLocator locator;

    public VideoProcessor() {
        try {
            this.locator = new DefaultFFMPEGLocator();
            this.encoder = new Encoder(this.locator);
            enabled = true;
        }
        catch (IllegalStateException ise) {
            logger.error("Error while starting the VideoService", (Throwable)ise);
        }
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void catClipsTogether(List<File> videos, File destination, VideoProgressListener progress) throws FileNotFoundException, IllegalArgumentException, InputFormatException, EncoderException {
        assert (enabled);
        progress.onBegin();
        try (AutoRemoveableFile mergeFile = this.prepareMergeInstructions(videos, destination);){
            MultimediaObject toMerge = this.fromFile(mergeFile);
            EncodingAttributes attributes = new EncodingAttributes();
            attributes.setInputFormat("concat");
            attributes.setSafe(0);
            VideoAttributes videoAttributes = new VideoAttributes();
            videoAttributes.setCodec("copy");
            attributes.setVideoAttributes(videoAttributes);
            this.encoder.encode(toMerge, destination, attributes, (EncoderProgressListener)new EncoderProgressAdapter(progress));
        }
        progress.onComplete();
    }

    private MultimediaObject fromFile(File source) {
        return new MultimediaObject(source, this.locator);
    }

    private AutoRemoveableFile prepareMergeInstructions(List<File> videos, File destination) throws FileNotFoundException {
        AutoRemoveableFile mergeFile = new AutoRemoveableFile(destination.getParentFile(), destination.getName() + ".merge.txt");
        try (PrintStream fout = new PrintStream(mergeFile);){
            fout.println(videos.stream().map(File::getAbsolutePath).collect(Collectors.joining("'\nfile '", "file '", "'")));
        }
        return mergeFile;
    }
}

